/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.blocks.BlockHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnFarmlandTillCheck;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.OnPlayerInteract;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.effects.ParticleHandler;
import com.mlib.effects.SoundHandler;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.math.AnyPos;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class HarvesterEnchantment
extends CustomEnchantment {
    public HarvesterEnchantment() {
        this.rarity(Enchantment.Rarity.UNCOMMON).category(Registries.HOE).slots(EquipmentSlots.BOTH_HANDS).maxLevel(3).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 15);
    }

    @AutoInstance
    public static class Handler {
        final DoubleConfig growChance = new DoubleConfig(0.04, Range.CHANCE);
        final Supplier<HarvesterEnchantment> enchantment = Registries.HARVESTER;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("Harvester").comment("Gives the option of right-click harvesting and the chance to grow nearby crops.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnPlayerInteract.listen(this::increaseAgeOfNearbyCrops).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> this.enchantment.get().hasEnchantment(data.itemStack))).addCondition(Condition.predicate(data -> data.event instanceof PlayerInteractEvent.RightClickBlock)).addCondition(Condition.predicate(data -> BlockHelper.isCropAtMaxAge((Level)data.getLevel(), (BlockPos)new BlockPos((Vec3i)data.event.getPos())))).addConfig((IConfigurable)this.growChance.name("extra_grow_chance").comment("Chance to increase an age of nearby crops.")).insertTo(group);
            OnLoot.listen(this::replant).addCondition(Condition.isServer()).addCondition(OnLoot.hasBlockState()).addCondition(OnLoot.hasEntity()).addCondition(OnLoot.hasTool()).addCondition(OnLoot.hasOrigin()).addCondition(Condition.predicate(data -> BlockHelper.isCropAtMaxAge((Level)data.getLevel(), (BlockPos)new BlockPos(data.origin)))).insertTo(group);
            OnFarmlandTillCheck.listen((Consumer)OnFarmlandTillCheck.INCREASE_AREA).addCondition(Condition.predicate(data -> this.enchantment.get().hasEnchantment(data.itemStack))).insertTo(group);
        }

        private void increaseAgeOfNearbyCrops(OnPlayerInteract.Data data) {
            this.collectCrop(data.getServerLevel(), data.player, data.position, data.itemStack);
            this.tickNearbyCrops(data.getServerLevel(), data.position, data.itemStack);
            this.damageHoe(data.itemStack, data.player, data.hand);
            SoundHandler.BONE_MEAL.play(data.getLevel(), AnyPos.from((BlockPos)data.position).vec3());
        }

        private void collectCrop(ServerLevel level, Player player, BlockPos position, ItemStack itemStack) {
            BlockState blockState = level.m_8055_(position);
            Block block = blockState.m_60734_();
            block.m_6240_((Level)level, player, position, blockState, null, itemStack);
        }

        private void tickNearbyCrops(ServerLevel level, BlockPos position, ItemStack itemStack) {
            int range = this.enchantment.get().getEnchantmentLevel(itemStack);
            for (int z = -range; z <= range; ++z) {
                for (int x = -range; x <= range; ++x) {
                    if (x == 0 && z == 0) continue;
                    BlockPos neighbourPosition = position.m_7918_(x, 0, z);
                    BlockState blockState = level.m_8055_(position.m_7918_(x, 0, z));
                    Block block = blockState.m_60734_();
                    if (!(block instanceof CropBlock) && !(block instanceof NetherWartBlock)) continue;
                    int particlesCount = 1;
                    if (Random.tryChance((double)((Double)this.growChance.get()))) {
                        BlockHelper.growCrop((Level)level, (BlockPos)neighbourPosition);
                        particlesCount = 3;
                    }
                    ParticleHandler.AWARD.spawn(level, AnyPos.from((BlockPos)position).vec3(), particlesCount);
                }
            }
        }

        private void damageHoe(ItemStack itemStack, Player player, InteractionHand hand) {
            player.m_21011_(hand, true);
            itemStack.m_41622_(1, (LivingEntity)player, owner -> owner.m_21190_(hand));
        }

        private void replant(OnLoot.Data data) {
            assert (data.origin != null && data.blockState != null && data.getLevel() != null);
            BlockPos position = new BlockPos(data.origin);
            Block block = data.blockState.m_60734_();
            Item seedItem = Handler.getSeedItem(data.getLevel(), data.blockState, position);
            for (ItemStack itemStack : data.generatedLoot) {
                if (itemStack.m_41720_() != seedItem) continue;
                itemStack.m_41764_(itemStack.m_41613_() - 1);
                data.getLevel().m_46597_(position, block.m_49966_());
                return;
            }
            data.getLevel().m_46597_(position, Blocks.f_50016_.m_49966_());
        }

        private static Item getSeedItem(Level level, BlockState blockState, BlockPos position) {
            return blockState.m_60734_().m_7397_((BlockGetter)level, position, blockState).m_41720_();
        }
    }
}

